import java.awt.BorderLayout;

import javax.swing.JFrame;

import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkCone;
import vtk.vtkConeSource;
import vtk.vtkContourFilter;
import vtk.vtkCutter;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkLookupTable;
import vtk.vtkPanel;
import vtk.vtkPlane;
import vtk.vtkScalarBarActor;

public class testVtk6 {

	public static void main(String[] args) {

		vtkPanel panel = new vtkPanel();

		vtkDataSetReader demo = new vtkDataSetReader();
		demo.SetFileName("/home/vtk/imagedata.vtk");
		demo.Update();
		demo.CloseVTKFile();
		
		// get range source data
		double[] range = demo.GetOutput().GetScalarRange();
		
		// implicit function
		vtkPlane plane = new vtkPlane();
		plane.SetOrigin(1, 1, 1);
		plane.SetNormal(0, 1, 0);	
		

		vtkCone cone = new vtkCone();
		cone.SetAngle(45);

		//filter
		vtkCutter filter = new vtkCutter();
		filter.SetInputConnection(demo.GetOutputPort());
		filter.SetCutFunction(plane);
		filter.Update();
		// get range filter
		double[] range_filter =  filter.GetOutput().GetScalarRange();
		
		//filter 2
		vtkContourFilter filter2 = new vtkContourFilter();
		filter2.GenerateValues(10, range_filter);
		filter2.SetInputConnection(filter.GetOutputPort());
		
		//LookupeTable
		vtkLookupTable ltable = new vtkLookupTable();
		ltable.SetHueRange(0.6667, 0);
		ltable.Build();
		
		// mapper
		vtkDataSetMapper demoMapper = new vtkDataSetMapper();
		demoMapper.SetInputConnection(filter2.GetOutputPort());
		demoMapper.SetLookupTable(ltable);
		demoMapper.SetScalarRange(range_filter);

		// demomapper actor 
		vtkActor actor2 = new vtkActor();
		actor2.SetMapper(demoMapper);

		// scalar bar actor
		vtkScalarBarActor scalarBar = new vtkScalarBarActor();
		scalarBar.SetLookupTable(ltable);
		
		
		panel.GetRenderer().AddActor(actor2);
		panel.GetRenderer().AddActor2D(scalarBar);
		//
		JFrame f = new JFrame("");
		f.getContentPane().setLayout(new BorderLayout());
		f.getContentPane().add(panel, BorderLayout.CENTER);
		f.setDefaultCloseOperation(1);
		f.setSize(800, 800);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
	}

}
